unit fSplash;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, fBase508Form, VA508AccessibilityManager, Vcl.AppEvnts;

type
  TfrmSplash = class(TfrmBase508Form)
    pnlMain: TPanel;
    lblVersion: TStaticText;
    lblCopyright: TStaticText;
    pnlImage: TPanel;
    Image1: TImage;
    lblSplash: TStaticText;
    pnl508Disclaimer: TPanel;
    mm: TMemo;
    ae: TApplicationEvents;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure mmChange(Sender: TObject);
    procedure aeIdle(Sender: TObject; var Done: Boolean);
  private
    { Private declarations }
    procedure UpdateMemoSize;
  public
    { Public declarations }
  end;

var
  frmSplash: TfrmSplash;

procedure ShowSplash;

implementation

{$R *.DFM}

uses VAUtils;

procedure ShowSplash;
begin
  if not assigned(frmSplash) then
    frmSplash := TFrmSplash.Create(Application);
{$IFDEF DEBUG}
  frmSplash.mm.ReadOnly := False;
  frmSplash.mm.SelStart := Length(frmSplash.mm.Lines.Text);
{$ENDIF}
  frmSplash.ShowModal;
end;

procedure TfrmSplash.aeIdle(Sender: TObject; var Done: Boolean);
begin
  inherited;
{$IFDEF DEBUG}
{$ELSE}
  HideCaret(mm.Handle);
{$ENDIF}
end;

procedure TfrmSplash.FormCreate(Sender: TObject);
begin
  inherited;
  lblVersion.Caption := 'version ' + FileVersionValue(Application.ExeName,
    FILE_VER_FILEVERSION);
  lblSplash.Invalidate;
end;

procedure TfrmSplash.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  if Key = VK_Escape then
    Close;
end;

procedure TfrmSplash.FormShow(Sender: TObject);
begin
  inherited;
  UpdateMemoSize;
end;

procedure TfrmSplash.mmChange(Sender: TObject);
begin
  inherited;
  UpdateMemoSize;
end;

procedure TfrmSplash.UpdateMemoSize;
var
  newHeight,
  LineHeight: Integer;
  DC: HDC;
  SaveFont : HFont;
  Metrics : TTextMetric;
  Increase: Integer;
  LC: Integer;
begin
  DC := GetDC(mm.Handle);
  SaveFont := SelectObject(DC, mm.Font.Handle);
  GetTextMetrics(DC, Metrics);
  SelectObject(DC, SaveFont);
  ReleaseDC(mm.Handle, DC);
  LineHeight := Metrics.tmHeight;
  Increase := mm.Height;
  LC := mm.Lines.Count;
  newHeight := (LC + 1) * LineHeight + 8;
  Increase := newHeight - Increase;
  self.Height := self.Height + Increase;
end;

end.
